% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_logs_if_missing.R
\name{create_logs_if_missing}
\alias{create_logs_if_missing}
\title{Create a table with the SCDB log structure if it does not exists}
\usage{
create_logs_if_missing(conn, log_table)
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{log_table}{(\verb{id-like object})\cr
A table specification where the logs should exist (coercible by \code{id()}).}
}
\value{
Invisibly returns the generated (or existing) log table.
}
\description{
Create a table with the SCDB log structure if it does not exists
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- get_connection()
  log_table <- id("test.logs", conn = conn, allow_table_only = TRUE)

  create_logs_if_missing(conn, log_table)

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
