% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distfilter.R
\name{distfilter}
\alias{distfilter}
\title{Filter locations by distance}
\usage{
distfilter(sdata, max.dist = 100, method = 1, ia = NA)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees.}

\item{max.dist}{A numeric value specifying a threshold of distance between successive locations. Default is 100 km.}

\item{method}{An integer specifying how locations should be filtered with \emph{max.dist}. 
A location is removed if the distance from a previous and(1)/or(2) to a subsequent location exceeds \emph{max.dist}. 
Default is 1 (both way).}

\item{ia}{An integer (0 to 180) specifying an inner angle (in degrees) between consecutive locations, 
beyond which the locations are considered potential outliers. 
Default (NA) ignores this option. See details.}
}
\value{
The input data is returned without locations identified by this filter. 
The following columns are added: "pDist", "sDist", 'inAng'. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively.
"inAng" is the degree between the bearings of lines joining successive location points.
}
\description{
This function removes locations that are located beyond a specified distance.
}
\details{
This function removes locations if the distance from a previous and/or to a subsequent location exceeds \emph{max.dist} and
the inner angle is less than \emph{ia}. If \emph{ia} is NA (default), inner angles are not considered in the filtering.
}
\examples{
#### Load data sets
## Fastloc GPS data obtained from a green turtle
data(turtle)

## A Map for the example site
data(Australia)
data(SandyStrait)


#### Filter temporal and/or spatial duplicates
turtle.dup <- dupfilter(turtle, step.time=1/60, step.dist=0.001)
 

#### distfilter
turtle.dist <- distfilter(turtle.dup, max.dist = 50, ia = 20)


#### Plot data removed or retained by ddfilter
## Entire area
p1 <- to_map(turtle.dup, bgmap=Australia, point.size = 2, line.size = 0.5, axes.lab.size = 0, 
            multiplot = FALSE, point.bg = "red",
            title.size=15, title="Entire area")[[1]] + 
  geom_point(aes(x=lon, y=lat), data=turtle.dist, size=2, fill="yellow", shape=21)+
  geom_point(aes(x=x, y=y), data=data.frame(x=c(154, 154), y=c(-22, -22.5)), 
             size=3, fill=c("yellow", "red"), shape=21) + 
  annotate("text", x=c(154.3, 154.3), y=c(-22, -22.5), label=c("Retained", "Removed"), 
           colour="black", size=4, hjust = 0)

## Zoomed in
p2 <- to_map(turtle.dup, bgmap=SandyStrait, xlim=c(152.7, 153.2), ylim=(c(-25.75, -25.24)), 
            axes.lab.size = 0, point.size = 2, point.bg = "red", line.size = 0.5, 
            multiplot = FALSE, title.size=15, title="Zoomed in")[[1]] + 
geom_path(aes(x=lon, y=lat), data=turtle.dist, linewidth=0.5, colour="black", linetype=1) + 
geom_point(aes(x=lon, y=lat), data=turtle.dist, size=2, colour="black", shape=21, fill="yellow")

gridExtra::marrangeGrob(list(p1, p2), nrow=1, ncol=2)
}
\author{
Takahiro Shimada
}
