% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.tabu.helper.R
\name{sa.tabu.helper}
\alias{sa.tabu.helper}
\title{Tabu Search to Optimize Functions of Continuous Variables}
\usage{
sa.tabu.helper(
  n.var,
  f,
  maximum = FALSE,
  max.len = 1,
  max.tabu.size = 5,
  neigh.size = NULL,
  max.iter = NULL,
  max.iter.obj = NULL,
  range = c(-1, 1),
  r = 1e-05,
  verbose = TRUE
)
}
\arguments{
\item{n.var}{The dimension of search space.}

\item{f}{The objective function to be optimized.}

\item{maximum}{Logical. Maximize the objective function if TRUE,
minimize the objective function if FALSE.}

\item{max.len}{The length of the largest hypercube.}

\item{max.tabu.size}{The maximum size of the tabu list.}

\item{neigh.size}{The number of neighbors to search for
in each iteration.}

\item{max.iter}{The maximum number of iterations.}

\item{max.iter.obj}{The maximum number of successive iterations
without any improvement of the objective function value.}

\item{range}{The range for the parameter space in the tabu search.}

\item{r}{Radius of a tabu ball.}

\item{verbose}{Logical. Print the current best and overall best
objective functions if TRUE, no printing if FALSE.}
}
\value{
A list with three components:
best.param (vector): the best set of parameters found;
best.obj (scalar): the value of obj.fun corresponding
to best.param; and
model.history: the histry of model results.
}
\description{
A helper function that implements the main logic of tabu search
    to optimize objective functions in continuous domains.
}
\references{
P., & Berthiau, G. (1997).
    Fitting of tabu search to optimize functions of continuous
    variables. International journal for numerical methods
    in engineering, 40(13), 2449-2457.
}
