% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMsensitvity.R
\name{SEMsensitivity}
\alias{SEMsensitivity}
\title{Run Specified Test for SEM Path Sign or Fit Measure Change}
\usage{
SEMsensitivity(
  df,
  model,
  var_one = NULL,
  var_two = NULL,
  PAR = NULL,
  threshold = 10,
  fit,
  estimates = NULL,
  conc = NULL,
  int = NULL,
  par_value = NULL,
  max_final,
  N,
  signFactor = NULL,
  equalCons = 0L,
  calcMeth = "Hessian",
  ratio = NULL,
  adaptA = NULL,
  alpha = NULL,
  maxTime = NULL,
  pruneNum = NULL,
  measureTest = "cfi",
  fitThreshold = 0.9,
  highGood = TRUE,
  method = 2,
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{var_one}{The first variable of interest.}

\item{var_two}{The second variable of interest.}

\item{PAR}{The path of interest.}

\item{threshold}{The threshold for percentage of data dropped.}

\item{fit}{The fit measure to assess the model.}

\item{estimates}{The estimates from the SEM model.}

\item{conc}{The convergence criterion for the SEM model.}

\item{int}{The interval for checking the parameter.}

\item{par_value}{The original value of the parameter of interest.}

\item{max_final}{The maximum number of influential data points to consider.}

\item{N}{The total number of data points.}

\item{signFactor}{A factor indicating the direction of parameter change (positive or negative).}

\item{equalCons}{The equality constraint used in the SEM model (default is 0).}

\item{calcMeth}{The method used for approximation (default is 'Hessian').}

\item{ratio}{The ratio used to determine the number of points to check using the exact method (default is 2) in combined method.}

\item{adaptA}{Logical indicating whether to use adaptive pruning (default is FALSE).}

\item{alpha}{Manual tuning parameter (default is 0.25).}

\item{maxTime}{Maximum time allowed for the search in seconds (default is 300).}

\item{pruneNum}{The number of branches to explore from each node (default is 3).}

\item{measureTest}{The fit measurement name to be tested (e.g., "cfi", "tli", "rmsea"). Default is "cfi".}

\item{fitThreshold}{The threshold of the fit measurement. For example, for CFI (measureTest = "cfi"), the threshold could be 0.9. Default is 0.9.}

\item{highGood}{A boolean indicating whether higher values of the fit measure are better. For instance, for CFI, this should be set to TRUE. Default is TRUE.}

\item{method}{The method name or index specifying which test to run. Default is "Naive Method with Approximate Influence".}

\item{...}{Other arguments.
\describe{
\item{1: }{\code{"Naive Method with Exact Influence"}}
\item{2: }{\code{"Naive Method with Approximate Influence"}}
\item{3: }{\code{"Specified Approximation Method"}}
\item{4: }{\code{"Simple Depth Method"}}
\item{5: }{\code{"Combined Method"}}
\item{7: }{\code{"Negamax Search Algorithm Function"}}
\item{8: }{\code{"Use Depth Method to Try to Switch Sign of Parameter"}}
\item{9: }{\code{"Use Depth Method to Try to Switch Sign of Parameter with Negamax"}}
\item{11: }{\code{"Simulated Annealing Method"}}
\item{12: }{\code{"Particle Swarm Optimization"}}
\item{13: }{\code{"Brute Search with Cut Method"}}
\item{10: }{\code{"Use depth method to drop fit measure below threshold"}}
\item{61: }{\code{"Finding case deletions required to change fit metric using exact influences"}}
\item{62: }{\code{"Finding case deletions required to change fit metric using approximate method"}}
}}
}
\value{
A list containing the results of the specified test.
}
\description{
This function runs a specified test by method name or method index to determine either (1) when a specific path in a Structural Equation Modeling (SEM) model changes sign (positive or negative) by iteratively removing data points, or (2) whether a fit measure (e.g., CFI, TLI) exceeds or falls below a specified threshold (e.g., 0.9). The function outputs relevant results for the specified test.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)
library(R.utils)


# Import data
df <- PoliticalDemocracy

# Build Model
model <- '
  # measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  # regressions
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  # residual correlations
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

var_one <- 'dem65' # first term
var_two <- 'ind60' # second term
PAR <- c("dem65~ind60") # full relation
threshold <- 10

# Fit SEM model
fit <- sem(model, data = df)
summary(fit)

# Get Estimates of Parameters from SEM
estimates <- parameterEstimates(fit)

# Determine The Value of The Parameter of Interest
conc <- data.frame(lhs = estimates$lhs, rhs = estimates$rhs, est = estimates$est)
int <- conc \%>\% filter(lhs == var_one & rhs == var_two)
par_value <- int$est # this is the value of the parameter of interest

# Compute max number of points to be dropped
max_final <- ceiling(threshold * nrow(df) / 100) # perform rounding if necessary
N <- nrow(df) # store number of observations in df for convenience

# Determine whether parameter is negative or positive in order
# to assess which direction to perturb it
signFactor <- ifelse(par_value >= 0L, TRUE, FALSE)

# Run specified test by method name
result_by_name <- SEMsensitivity(df, model, var_one, var_two, PAR, threshold, fit,
estimates, conc, int, par_value, max_final, N, signFactor,
method = "Naive Method with Exact Influence")
summary(result_by_name)

# Run specified test by method index
result_by_index <- SEMsensitivity(df, model, var_one, var_two, PAR, threshold, fit,
estimates, conc, int, par_value, max_final, N, signFactor, method = 1)
summary(result_by_index)
}
}
