% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test10.R
\name{Test10}
\alias{Test10}
\title{Use depth method to drop fit measure below threshold}
\usage{
Test10(
  df,
  model,
  fit,
  max_final,
  N,
  measureTest = "cfi",
  fitThreshold = 0.9,
  highGood = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{fit}{The SEM object after fitting the model.}

\item{max_final}{The maximum number of influential data points to consider for removal.}

\item{N}{The total number of data points.}

\item{measureTest}{The fit measurement name to be tested (e.g., "cfi", "tli", "rmsea"). Default is "cfi".}

\item{fitThreshold}{The threshold of the fit measurement. For example, for CFI (measureTest = "cfi"), the threshold could be 0.9. Default is 0.9.}

\item{highGood}{A boolean indicating whether higher values of the fit measure are better. For instance, for CFI, this should be set to TRUE. Default is TRUE.}

\item{...}{Other arguments.}
}
\value{
A list of class \code{TestResult10} containing:
\item{methodname}{The name of the method used.}
\item{testindex}{The index of the test performed.}
\item{original_fit_value}{The original value of the fit measurement before data points were removed.}
\item{final_fit_value}{The fit value after the influential data points were removed.}
\item{num_drops}{The number of data points dropped to achieve the desired fit value reduction.}
\item{depthdiffFit}{The difference between the original fit value and the threshold.}
\item{depthDropScore}{The cumulative drop in the fit value after removing points.}
\item{final_drops}{The indices of the most influential data points dropped.}
}
\description{
This function uses the depth method to iteratively remove the most influential data points based on influence scores to reduce the fit measure below a specified threshold. The method is based on approximating the influence of each data point and is similar to TEST 8 but focused on fit metrics like CFI, RMSEA, etc.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)

# Import data
df <- PoliticalDemocracy

# Build SEM model
model <- '
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
'

fit <- lavaan::sem(model, data = df)
max_final <- ceiling(10 * nrow(df) / 100)  # dropping 10\% of the data points
N <- nrow(df)

Test10_result <- Test10(df, model, fit, max_final, N,
measureTest = "cfi", fitThreshold = 0.9, highGood = TRUE)
summary(Test10_result)
}
}
