% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootspat_str.R
\name{fr2prob}
\alias{fr2prob}
\title{Adjust probability of sampling based on frequency of occurrences.}
\usage{
fr2prob(x, rprob = NULL)
}
\arguments{
\item{x}{SpatRaster. A presence-absence raster (stack).}

\item{rprob}{SpatRaster. A raster (stack) of probabilities.}
}
\value{
numeric vector
}
\description{
This function is used to adjust the probability of a species to be sampled
across the raster, so that the sampled frequency of occurrence of the
species is closer to the observed
}
\examples{
library(SESraster)
library(terra)
# load random species distributions
r <- load_ext_data()

# applying the function
fr2prob(r)


f <- system.file("ex/elev.tif", package="terra")
r <- rast(f)
set.seed(510)
r10 <- rast(lapply(1:18,
                function(i, r, mn, mx){
                  app(r, function(x, t){
                    sapply(x, function(x, t){
                       x<max(t) & x>min(t)
                    }, t=t)
                  }, t=sample(seq(mn, mx), 2))
                }, r=r, mn=minmax(r)[1]+10, mx=minmax(r)[2]-10))

names(r10) <- paste("sp", 1:nlyr(r10))
fr2prob(r10)
# raw frequencies
unlist(terra::global(r10, function(x)sum(x, na.rm=TRUE)))

}
