% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_design.R
\name{clustering.design}
\alias{clustering.design}
\title{Designs generated by clustering algorithms}
\usage{
clustering.design(
  n,
  p,
  X = NULL,
  D.ini = NULL,
  multi.start = 1,
  alpha = 1,
  Lloyd.iter.max = 100,
  cen.iter.max = 10,
  Lloyd.tol = 1e-04,
  cen.tol = 1e-04
)
}
\arguments{
\item{n}{design size.}

\item{p}{design dimension.}

\item{X}{candidate points in \eqn{[0,1]^p}. If X is not provided, Sobol points is generated as cluster points.}

\item{D.ini}{initial design points. If D.ini is not provided, Sobol points are generated as initial design.}

\item{multi.start}{number of starting designs (cluster centers).}

\item{alpha}{power of the Euclidean distance.}

\item{Lloyd.iter.max}{maximum number of iterations for the Lloyd algorithm.}

\item{cen.iter.max}{maximum number of iterations for the center calculation for each cluster.}

\item{Lloyd.tol}{minimum relative change for the Lloyd algorithm to continue.}

\item{cen.tol}{minimum relative change for the center calculation algorithm to continue.}
}
\value{
\item{design}{final design points.}
\item{cluster}{cluster assignment for each cluster points.}
\item{cluster.error}{final cluster error.}
}
\description{
This function is for producing designs by minimizing the clustering error.
}
\details{
\code{clustering.design} produces a design by clustering algorithms. It minimize the clustering error (see \code{\link{cluster.error}}) by Lloyd's algorithm. When \eqn{\alpha > 2}, accelerated gradient descent is used to find the center for each cluster (Mak, S. and Joseph, V. R. 2018). When \eqn{\alpha \leq 2}: Weizfeld algorithm is used to find the center for each cluster. Let \eqn{\bm{x}^{(0)}_i=\bm{x}_i} denote the initial position of the \eqn{i}th center and and let \eqn{\bm{S}_i} represent the points within its Voronoi cell. The center is then updated as: \eqn{\bm{x}^{(k+1)}_i = \left.\left(\sum_{\bm{s}\in\bm{S}_i}\frac{\bm{s}}{\|\bm{s}-\bm{x}^{(k)}_i\|_2^{2-\alpha}}\right)\middle/ \left(\sum_{\bm{s}\in\bm{S}_i}\frac{1}{\|\bm{s}-\bm{x}^{(k)}_i\|_2^{2-\alpha}}\right)\right. \quad \text{for } k=0, 1, \dots.}
}
\examples{
n = 20
p = 3
X = spacefillr::generate_sobol_set(1e5*p, p)
D = clustering.design(n, p, X)

}
\references{
Mak, S. and Joseph, V. R. (2018), “Minimax and minimax projection designs using clustering,” Journal of Computational and Graphical Statistics, 27, 166–178.
}
