% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov1_2012Fisher.R
\name{cov1.2012Fisher}
\alias{cov1.2012Fisher}
\title{One-sample Test for Covariance Matrix by Fisher (2012)}
\usage{
cov1.2012Fisher(X, Sigma0 = diag(ncol(X)), type)
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{type}{\code{1} or \code{2} for corresponding statistic from the paper.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X} and hypothesized covariance matrix \eqn{\Sigma_0}, it tests
\deqn{H_0 : \Sigma_x = \Sigma_0\quad vs\quad H_1 : \Sigma_x \neq \Sigma_0}
using the procedure by Fisher (2012). This method utilizes the generalized form of the inequality
\deqn{\frac{1}{p} \sum_{i=1}^p (\lambda_i^r - 1)^{2s} \ge 0} and offers two types of 
test statistics \eqn{T_1} and \eqn{T_2} corresponding to the case \eqn{(r,s)=(1,2)} and \eqn{(2,1)} respectively.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
cov1.2012Fisher(smallX) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1000
counter1 = rep(0,niter)  # p-values of the type 1
counter2 = rep(0,niter)  # p-values of the type 2
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=50) # (n,p) = (5,50)
  counter1[i] = ifelse(cov1.2012Fisher(X, type=1)$p.value < 0.05, 1, 0)
  counter2[i] = ifelse(cov1.2012Fisher(X, type=2)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'cov1.2012Fisher' \n","*\n",
"* empirical error with statistic 1 : ", round(sum(counter1/niter),5),"\n",
"* empirical error with statistic 2 : ", round(sum(counter2/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{fisher_testing_2012}{SHT}
}
\concept{covariance}
