% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.interaction.model.R
\name{fit.interaction.model}
\alias{fit.interaction.model}
\title{Cox model two features separately and together}
\usage{
fit.interaction.model(
  feature1,
  feature2,
  expression.data,
  survival.data,
  data.type.ordinal = FALSE,
  centre.data = "median"
)
}
\arguments{
\item{feature1}{String indicate what feature (gene/probe/etc.) should be
extracted for analysis}

\item{feature2}{String indicate what feature (gene/probe/etc.) should be
extracted for analysis}

\item{expression.data}{A list where each component is an expression matrix
(patients = columns, features = rows) for a different dataset}

\item{survival.data}{A list where each component is an object of class Surv}

\item{data.type.ordinal}{Logical indicating whether to treat this datatype
as ordinal. Defaults to FALSE}

\item{centre.data}{A character string specifying the centre value to be used for 
scaling data. Valid values are: 'median', 'mean', or a user defined numeric threshold
e.g. '0.3' when modelling methylation beta values. This value is used for both scaling
as well as for dichotomising data for estimating univariate betas from Cox model.
Defaults to 'median'}
}
\value{
Returns a vector of six elements containing (HR,P) pairs for
feature1, feature2, and the interaction
}
\description{
Using a meta-analysis dataset take two features and Cox model them
separately and together and extract HRs and p-values.
}
\details{
The interaction model compares cases where feature1 and feature2 concord
(both high or both low) to those where they do not. That is, the model is y
= x1 + x2 + (x1 == x2) and not the typical y = x1 + x2 + x1:x2
}
\examples{

data.dir <- get.program.defaults()[["test.data.dir"]];
data.types <- c("mRNA");
x1 <- load.cancer.datasets(
  datasets.to.load = c('Breastdata1'),
  data.types = data.types,
  data.directory = data.dir
  );
x2 <- fit.interaction.model(
  feature1 = "1000_at", 
  feature2 = "2549_at",
  expression.data = x1$all.data[[data.types[1]]],
  survival.data = x1$all.survobj
  );

}
\author{
Syed Haider & Paul C. Boutros
}
\keyword{survival}
