% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.SCR.R
\name{auto.SCR}
\alias{auto.SCR}
\title{Automated creation of a Simultaneous Confidence Region (SCR) for the estimated function}
\usage{
auto.SCR(
  ts,
  c,
  d,
  b_time,
  b_timese,
  mp_type,
  type,
  ops,
  m = "MV",
  fix_num = 0,
  r = 1,
  s = 1,
  per = 0,
  k = 0,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{the maximum value of number of basis for time input}

\item{d}{the maximum value of number of basis for variate input}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{type}{select type of estimation."fixt" indicates fix time t estimation. "fixx" represents fixed variate estimation}

\item{ops}{Criteria for choosing the number of bases are provided by the package, offering four options: "AIC," "BIC," "CV," and "Kfold," each corresponding to a specific Criteria}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{fix_num}{fix_num indicates the use of fixed-value nonlinear time series regression. If "fixt" is chosen, it represents a fixed time value. Otherwise,
if not selected, it pertains to a fixed variate value}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{per}{the percentage for test set used in "CV" option}

\item{k}{the number of fold used in "Kfold" option}

\item{upper}{upper The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper}
}
\value{
A list containing dataframes with three columns each. The first column corresponds to input values. The second column contains values of the estimated function, along with
their upper and lower bounds. The third column is a factor that indicates the types associated with the values in the second column.
}
\description{
This function generates a Simultaneous Confidence Region (SCR) for the estimated function with chosen bases.
}
