% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.plot.R
\name{fit.plot}
\alias{fit.plot}
\title{Visualization of estimation}
\usage{
fit.plot(
  res_esti,
  ops,
  mp_type,
  title = "",
  lower = -1.3,
  upper = 1.3,
  domain = 10
)
}
\arguments{
\item{res_esti}{the result of estimation}

\item{ops}{select type of estimation."nfix" refers to no fix estimation. "fixt" indicates fix time t estimation.
"fixx" represents fix variate estimation}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{title}{give the title for plot}

\item{lower}{give the lower bound for scale limits, the default is -1.3}

\item{upper}{give the upper bound for scale limits, the default is 1.3}

\item{domain}{The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -domain to domain.}
}
\value{
the plot shows estimated function
}
\description{
Visualization of estimation
}
\examples{
generate_nAR1 = function(n, v){
 ts = c()
 w = rnorm(n, 0, 1/v)
 x_ini = runif(1,0,1)
 for(i in 1:n){
   if(i == 1){
     ts[i] = sin(2*pi*(i/n))*exp(-x_ini^2)  + w[i] #
   } else{
     ts[i] = sin(2*pi*(i/n))*exp(-ts[i-1]^2) + w[i]
   }
 }
 return(ts)
}
ts  = generate_nAR1(200, 1) # change sample size in real case
res_esti = fix.fit(ts, 5, 2, "Legen", "Legen", "algeb", "fixt", 0.1)
fit.plot(res_esti[[1]], "fixt", "algeb")
}
