% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{combine}
\alias{combine}
\title{Combine two colony objects}
\usage{
combine(strong, weak)
}
\arguments{
\item{strong}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{weak}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}
}
\value{
a combined \code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 2 function that combines two Colony or MultiColony objects
  into one or
  two colonies objects of the same length to one. For example, to combine a
  weak and a strong colony (or MultiColony). Workers and drones of the weak
  colony are added to the strong. User has to remove the weak colony (or
  MultiColony) from the workspace.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create weak and strong Colony and MultiColony class
colony1 <- createColony(x = basePop[2])
colony1 <- cross(colony1, drones = droneGroups[[1]])
colony2 <- createColony(x = basePop[3])
colony2 <- cross(colony2, drones = droneGroups[[2]])
apiary1 <- createMultiColony(basePop[4:6], n = 3)
apiary1 <- cross(apiary1, drones = droneGroups[3:5])
apiary2 <- createMultiColony(basePop[7:9], n = 3)
apiary2 <- cross(apiary2, drones = droneGroups[6:8])

# Build-up
colony1 <- buildUp(x = colony1, nWorkers = 100, nDrones = 20)
colony2 <- buildUp(x = colony2, nWorkers = 20, nDrones = 5)
apiary1 <- buildUp(x = apiary1, nWorkers = 100, nDrones = 20)
apiary2 <- buildUp(x = apiary2, nWorkers = 20, nDrones = 5)

# Combine
nWorkers(colony1); nWorkers(colony2)
nDrones(colony1); nDrones(colony2)
colony1 <- combine(strong = colony1, weak = colony2)
nWorkers(colony1); nWorkers(colony2)
nDrones(colony1); nDrones(colony2)
rm(colony2)

nWorkers(apiary1); nWorkers(apiary2)
nDrones(apiary1); nDrones(apiary2)
apiary1 <- combine(strong = apiary1, weak = apiary2)
nWorkers(apiary1); nWorkers(apiary2)
nDrones(apiary1); nDrones(apiary2)
rm(apiary2)
}
