% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterACF.R
\name{scatterACF}
\alias{scatterACF}
\title{Scatterplot of Two Selected-lag Autocorrelation Functions}
\usage{
scatterACF(x, lags = c(1, 2))
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{lags}{Set of lags. Default values are 1, 2.}
}
\value{
A list containing:
\itemize{
\item acf1 - Autocorrelation function of order lags[1].
\item acf2 - Autocorrelation function of order lags[2].
}
}
\description{
Scatterplot of two selected-lag ACFs.
}
\examples{
data(TaiwanAirBox032017)
output <- scatterACF(TaiwanAirBox032017[,1:100])
}
