% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{Election2005}
\alias{Election2005}
\title{Presidential Election 2005}
\format{
A data frame with 6 columns and 3494 rows.
\describe{
\item{\code{Year}}{Year of the presidential election}
\item{\code{District}}{District Names}
\item{\code{Electorate}}{Electorate Names, Postal District Votes, Final District Results and Displaced District Votes}
\item{\code{ColNames}}{Candidate Names, Total No of Valid Votes, No of Rejected Votes, Total No of Votes Polled and No of Registered Electors}
\item{\code{Votes}}{No of votes for the ColNames variable}
\item{\code{Percentage}}{Percentage of votes with regard to the No of Registered Electors and the Total No of Votes Polled for Total No of Votes Polled and all other ColNames variable, respectively}
}
}
\source{
Extracted from the pdf published by the Sri Lankan Elections commission at
\url{https://elections.gov.lk}
or the project that I have completed in scraping the data from the pdf file at :
\url{https://github.com/Amalan-ConStat/PresidentialElection}
}
\usage{
data(Election2005)
}
\description{
The fifth presidential election of Sri Lanka was held in 2005. Its results are published
as a pdf file. The data available in this file is scraped and summarised as a data-frame Election2005.
}
\details{
There are 22 districts and 160 electorates in Sri Lanka. In 2005 thirteen candidates participated in this election and
Mahinda Rajapaksha became the fourth executive president.
}
\examples{
Election2005[Election2005$District == "Colombo" & Election2005$Electorate == "Colombo-North",]

}
\keyword{datasets}
