% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.functions.R
\name{matrix2graph}
\alias{matrix2graph}
\title{Convert transition matrix to an igraph object}
\usage{
matrix2graph(trans, SOM, SOM.hc, col.set, diag = FALSE)
}
\arguments{
\item{trans}{a transition matrix (usually obtained from comp.trans.mat)}

\item{SOM}{a kohonen object that form the network}

\item{SOM.hc}{a vector of cluster assignment for SOM neurons}

\item{col.set}{a vector of colors used for the SOM clusters}

\item{diag}{boolean condition to include diagonal elements}
}
\value{
An igraph object, with SOM properties annotated
}
\description{
Function to convert a transition matrix to an igraph object
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Divide the SOM in the selected number of clusters
som_cl <- cutree(hclust(dist(som_model$codes[[1]], method="euclidean"), method="complete"), 4)
#Compute transition matrix
tr_mat <- comp.trans.mat(som_model, start = 1)
#Define a set of colors
colors <- c("#1f78b4", "#33a02c", "#e31a1c", "#ffff88", "#6a3d9a")
#Create graph object
net <- matrix2graph(tr_mat, som_model, som_cl, colors, diag=FALSE)
}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
