% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.struct.R
\name{read.struct}
\alias{read.struct}
\title{Read structure files}
\usage{
read.struct(file)
}
\arguments{
\item{file}{contains the name and the path to the pdb or gro file to be read}
}
\value{
Returns a list of class "struct" with the following components:

\item{atom}{ a data frame containing all atomic coordinate with a row per atom and a column per record type.}

\item{xyz}{ a numeric matrix of class "xyz" containing the atomic coordinate data.}

\item{box}{ a vector of box size.}

\item{format}{ The format of the original file }

\item{call}{ the matched call.}
}
\description{
Function to read pdb and gro files
}
\examples{
# Read structure file
struct <- read.struct(system.file("extdata", "HIF2a.gro", package = "SOMMD"))
}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
