% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silhouette.score.R
\name{silhouette.score}
\alias{silhouette.score}
\title{Silhouette score}
\usage{
silhouette.score(
  SOM,
  dist_clust = "euclidean",
  clust_method = "complete",
  interval = seq(2, 30)
)
}
\arguments{
\item{SOM}{the SOM object to cluster}

\item{dist_clust}{the metric for the distance calculation}

\item{clust_method}{the method for the clustering (passed to the hclust function}

\item{interval}{the cluster number on which the silhouette score will be computed}
}
\value{
A vector with the silhouette scores for all the frames
}
\description{
Function to compute the silhouette score for the clustering of SOM neurons
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Compute the silhouette profile
sil_score <- silhouette.score(som_model, clust_method="complete", interval=seq(2,8))

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
