% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{group_fairness}
\alias{group_fairness}
\title{group_fairness}
\usage{
group_fairness(
  specs,
  scores,
  target,
  group1,
  group2,
  cutoffs = seq(min(scores, na.rm = TRUE), max(scores, na.rm = TRUE), length = 100)
)
}
\arguments{
\item{specs}{specification vector; see description}

\item{scores}{vector of risk scores}

\item{target}{vector of values of target (which risk score aims to predict)}

\item{group1}{indices of group 1}

\item{group2}{indices of group 2}

\item{cutoffs}{score cutoffs at which to estimate metric (default 100 evenly-spaced)}
}
\value{
matrix of dimension length(cutoffs)x4, with (i,2g-1)th entry the relevant fairness metric for group g at the ith cutoff value and (i,2g)th entry the approximate standard error of the (i,2g-1)th entry
}
\description{
Estimates group fairness metric according to a specification vector of the form
}
\details{
c(A1,B1,C1,A2,B2,C2)

encoding a probability

P(A1,B1,C1|A2,B2,C2)

where

A1/A2 are events coded by 1:'score>= cutoff'; 0: 'score<cutoff' and NA: 1/TRUE
B1/B2 are events coded by 1:'target=TRUE'; 0: 'target=FALSE' and NA: 1/TRUE
C1/C2 are events coded by 1:'group=g'; and NA: 1/TRUE

For example, specs=c(NA,1,NA,0,NA,1) would encode false omission rate:

P(target=TRUE|score<cutoff,group=g)
}
\examples{
# See vignette
}
