% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPEVfunctions.R
\name{unsmoothed_penalized_EV}
\alias{unsmoothed_penalized_EV}
\title{unsmoothed_penalized_EV}
\usage{
unsmoothed_penalized_EV(m, lambda, k)
}
\arguments{
\item{m}{A matrix generated from a large dataset.}

\item{lambda}{A numeric vector of lambda values to use for the penalty.}

\item{k}{The number of eigenvectors we consider in the analysis.}
}
\value{
Returns eigenvectors 1 to k for the specified lambda value.
}
\description{
This function takes a matrix (m), a lambda value (lambda), and the number
of desired eigenvectors (k) as input. It then computes
eigenvectors 1 to k, penalized by the supplied lambda.
}
\examples{
# Generate a small matrix for testing
m <- matrix(rnorm(100), nrow = 10)
# Call function (using matrix, lambda, and k)
unsmoothed_penalized_EV(
  m = m,
  lambda = 1,
  k = 2
)
}
