% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_FDN2M1M2_inside.R
\name{DA_FDN2M1M2_inside}
\alias{DA_FDN2M1M2_inside}
\title{Internal calculation of estimating equation for DA_FDN2M1M2}
\usage{
DA_FDN2M1M2_inside(beta, CASEZ_2, CASEZhat_2, CASEZhat_22, CONTZ_1, CONTZhat_1,
  CONTZhat_2, CONTZhat_22, prob_case_2, prob_case_22, prob_cont_1, prob_cont_2,
  p, J, V, subset_2, subset_4, pwt_cont_2)
}
\arguments{
\item{beta}{Parameter \eqn{\beta}.}

\item{CASEZ_2, CASEZhat_2, CASEZhat_22}{CTR data(N2), details please see definition in the help of realdata_covariates.}

\item{CONTZ_1, CONTZhat_1}{control data(M1) from case-control study, details please
see definition in the help of realdata_covariates.}

\item{CONTZhat_2, CONTZhat_22}{BRFSS data(M2), details please see definition in the help of realdata_covariates.}

\item{prob_cont_1, prob_cont_2, prob_case_2, prob_case_22, pwt_cont_2}{please see definition in the help of realdata_alpha.}

\item{p}{Number of parameters, a constant value of 8.}

\item{J}{The derivative of the estimating equation.}

\item{V}{The variance of the estimating equation.}

\item{subset_2}{A vector of 1:(p-2).}

\item{subset_4}{A vector of 1:(p-2).}
}
\value{
A list of (f,J,V)
\enumerate{
\item f The final form of the estimating equation after adjusting eta.
\item J The derivative of the estimating equation.
\item V The variance of the estimating equation.
}
}
\description{
The internal function to solve the estimating equations constructed by combining pair (N2,M1) and (N2,M2). Since there is just one case data, no selection bias needed.
Since it's a internal function for function DA_FDN2M1M2, thus it's not a necessary
or important function.
}
\details{
The function solves estimating equation based on (N2,M1) and (N2, M2) with handling selection bias.
It also accounts for the uncertainty due to the estimated value of eta. The function will
output the estimating equation at current input value beta. Hence it can be used in "nleqslv" to solve for
\eqn{\beta}. Because the function also outputs J and V, the asymptotic variance of \eqn{\beta}
can be calculated in a straightforward way. \eqn{\hat{Z}_l} may be highly correlated with Z_d, so it is
removed in the estimation.
}

