% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_utils.R
\name{combine_formulas}
\alias{combine_formulas}
\title{Combine formulas}
\usage{
combine_formulas(lof, operator = "+", simplify = FALSE, env = parent.frame())
}
\arguments{
\item{lof}{list or vector of formulas to be linked}

\item{operator}{\code{"+"} (default), \code{"*"}, \code{":"} or another operator}

\item{simplify}{logical value, default FALSE. Determines whether the formula
should be expanded and simplified before output or not.}

\item{env}{the environment for the output formula}
}
\value{
model formula
}
\description{
Combining formulas by \code{+} or another operator.
This is particularly useful for linking tables in the case of table building with formulas.
}
\examples{
lof1 <- c(~a+b, ~a:c, ~c*d)
combine_formulas(lof1)
combine_formulas(lof1, operator = "*")
combine_formulas(lof1, simplify = TRUE)

# Intercept is included when needed
lof2 <- c(~a+b -1, ~a:c -1, ~c*d)
combine_formulas(lof2)
combine_formulas(lof2, simplify = TRUE)
combine_formulas(lof2[1:2])
combine_formulas(lof2[1:2], simplify = TRUE)
}
\author{
Daniel Lupp and Øyvind Langsrud
}
\keyword{internal}
