% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{comb}
\alias{comb}
\title{Generate all desired exponent vectors of a given degree.}
\usage{
comb(d, deg, N = choose(d + deg - 1, deg), vec, start = TRUE, parent,
  exclude = list())
}
\arguments{
\item{d}{A number. Controls the number of recursions before stopping.}

\item{deg}{A number. The desired degree of resulting exponent vectors.}

\item{N}{(optional) A number. Sets the number of exponent vectors that will
be generated.  If not supplied, all candidate vectors will be generated.}

\item{vec}{A vector.  Stores the current state of the generated vector during
recursion.}

\item{start}{(optional) Logical. A flag used to identify the initial call environment.}

\item{parent}{(optional) An environment. Stores the environment name of the initializing
function call.}

\item{exclude}{(optional) A list of integer vectors which is used to exclude the
generation of undesired exponent vectors.  \emph{e.g.} If 1 is a vector in
the list then any generated vector which is non-zero in the first column
and zero everywhere else will be thrown away.}
}
\value{
A matrix of exponent vectors
}
\description{
\code{comb} recursively generates all the desired exponent vectors of a given
degree and is called by \code{\link{degl}} to generate the matrix put into
the \code{basis} slot of the SSM object.
}
\details{
This function is called by \code{\link{degl}} during the process of
constructing the objects related to the basis of a smooth supersaturated
model.  It constructs the first \code{N} exponent vectors of degree \code{d},
excluding those which are non-zero only in the columns specified by vectors
listed in \code{exclude}.  It operates recursively.
}
\keyword{internal}

