% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress.R
\name{stress}
\alias{stress}
\title{Stressing Random Variables}
\usage{
stress(
  type = c("VaR", "VaR ES", "mean", "mean sd", "moment", "prob", "user"),
  x,
  ...
)
}
\arguments{
\item{type}{Type of stress, one of \code{"VaR", 
"VaR ES", "mean", "mean sd", "moment", "prob", "user"}.}

\item{x}{A vector, matrix or data frame
containing realisations of random variables. Columns of \code{x}
correspond to random variables; OR\cr
A \code{SWIM} object, where \code{x} corresponds to the
underlying data of the \code{SWIM} object.}

\item{...}{Arguments to be passed on, depending on \code{type}.}
}
\value{
An object of class \code{SWIM}, see \code{\link{SWIM}} 
    for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that stressed random variables fulfil given 
    probabilistic constraints (e.g. specified values for risk 
    measures), under the new scenario weights. Scenario weights are 
    selected by constrained minimisation of the relative entropy to the
    baseline model.
}
\examples{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res <- stress(type = "VaR", x = x, 
  alpha = 0.9, q_ratio = 1.05)
summary(res)   

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Pesenti2020SSRN}{SWIM}\cr

    \insertRef{Csiszar1975}{SWIM}
}
\seealso{
Other stress functions: 
\code{\link{stress_HARA_RM_w}()},
\code{\link{stress_RM_mean_sd_w}()},
\code{\link{stress_RM_w}()},
\code{\link{stress_VaR_ES}()},
\code{\link{stress_VaR}()},
\code{\link{stress_mean_sd_w}()},
\code{\link{stress_mean_sd}()},
\code{\link{stress_mean_w}()},
\code{\link{stress_mean}()},
\code{\link{stress_moment}()},
\code{\link{stress_prob}()},
\code{\link{stress_user}()},
\code{\link{stress_wass}()}
}
\author{
Silvana M. Pesenti
}
\concept{stress functions}
