% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress.R
\name{stress_wass}
\alias{stress_wass}
\title{Stressing Random Variables Using Wasserstein Distance}
\usage{
stress_wass(type = c("RM", "mean sd", "RM mean sd", "HARA RM"), x, ...)
}
\arguments{
\item{type}{Type of stress, one of \code{"RM", 
"mean sd", "RM mean sd", "HARA RM"}.}

\item{x}{A vector, matrix or data frame
containing realisations of random variables. Columns of \code{x}
correspond to random variables; OR\cr
A \code{SWIMw} object, where \code{x} corresponds to the
underlying data of the \code{SWIMw} object.}

\item{...}{Arguments to be passed on, depending on \code{type}.}
}
\value{
An object of class \code{SWIMw}, see \code{\link{SWIM}} 
    for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that stressed random variables fulfill given 
    probabilistic constraints (e.g. specified values for risk 
    measures), under the new scenario weights. Scenario weights are 
    selected by constrained minimisation of the Wasserstein Distance to the
    baseline model.
}
\examples{
\dontrun{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res <- stress_wass(type = "RM", x = x, 
  alpha = 0.9, q_ratio = 1.05)
summary(res)   
}

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Pesenti2020SSRN}{SWIM}\cr

    \insertRef{Csiszar1975}{SWIM}
}
\seealso{
Other stress functions: 
\code{\link{stress_HARA_RM_w}()},
\code{\link{stress_RM_mean_sd_w}()},
\code{\link{stress_RM_w}()},
\code{\link{stress_VaR_ES}()},
\code{\link{stress_VaR}()},
\code{\link{stress_mean_sd_w}()},
\code{\link{stress_mean_sd}()},
\code{\link{stress_mean_w}()},
\code{\link{stress_mean}()},
\code{\link{stress_moment}()},
\code{\link{stress_prob}()},
\code{\link{stress_user}()},
\code{\link{stress}()}
}
\author{
Zhuomin Mao
}
\concept{stress functions}
