#' Run Sample Size Calculator 'Shiny' App
#'
#' Launches the 'Shiny' app for Sample Size Calculation.
#'
#' @return Launches a 'Shiny' application.
#' @examples
#' if (interactive()) {
#'   run_SampleSizeCalc_app()
#' }
#' @export
run_SampleSizeCalc_app<- function() {
  app_dir <- system.file("shiny", package = "SampleSizeCalculator")
  if (app_dir == "") {
    stop("Could not find 'Shiny' app directory. Try re-installing `SampleSizeCalculator`.", call. = FALSE)
  }
  shiny::runApp(app_dir, display.mode = "normal")
}
