% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{SeaSondeRCS_MUSIC_validate_doppler_interpolation}
\alias{SeaSondeRCS_MUSIC_validate_doppler_interpolation}
\title{Validate Doppler Interpolation Factor for SeaSondeRCS Objects}
\usage{
SeaSondeRCS_MUSIC_validate_doppler_interpolation(value, seasonder_cs_object)
}
\arguments{
\item{value}{An integer specifying the Doppler interpolation factor. Must be one of 1, 2, 3, or 4.}

\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing metadata for Doppler bin calculations.}
}
\value{
The validated \code{doppler_interpolation} factor as an integer.
}
\description{
This function validates the \code{doppler_interpolation} factor for a \code{SeaSondeRCS} object, ensuring it is within the allowed range and does not result in exceeding the maximum number of Doppler bins after interpolation.
}
\details{
Doppler interpolation is a process that increases the number of Doppler bins by the specified factor before radial processing.
The function performs the following validations:
\itemize{
\item Ensures the \code{doppler_interpolation} factor is one of 1, 2, 3, or 4.
\item Computes the total number of Doppler bins after applying the specified interpolation factor. If this number exceeds 2048, the function aborts with a descriptive error message.
}

The maximum Doppler bins (2048) constraint is derived from CODAR's SeaSonde R8 Radial Config Setup, which specifies that the product of the interpolation factor and the original number of Doppler bins should not exceed this limit.
}
\section{Warnings}{

\itemize{
\item Using Doppler interpolation factors of 3x or 4x is not recommended.
\item Exceeding 2048 Doppler bins after interpolation will result in an error.
}
}

\seealso{
\code{\link{seasonder_getnDopplerCells}} for retrieving the number of Doppler bins,
\code{\link{seasonder_logAndAbort}} for error handling and logging.
}
