% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICCovDecomposition}
\alias{seasonder_MUSICCovDecomposition}
\title{Eigen Decomposition of the MUSIC Covariance Matrix}
\usage{
seasonder_MUSICCovDecomposition(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing the covariance matrices derived from cross-spectra data.}
}
\value{
An updated SeaSondeRCS object where each Doppler cell includes the eigenvalues and eigenvectors of its covariance matrix.
The eigenvalues are sorted in descending order, and the eigenvectors are aligned accordingly. The updates include:
\itemize{
\item \code{eigen$values}: A numeric vector containing the sorted eigenvalues for each Doppler cell.
\item \code{eigen$vectors}: A 3x3 matrix of the corresponding eigenvectors for each Doppler cell, aligned with the eigenvalues.
}
}
\description{
Performs the eigen decomposition of a MUSIC covariance matrix to obtain the eigenvalues
and eigenvectors. This decomposition is a critical step in the MUSIC algorithm for spectral
estimation and direction finding, as it enables the identification of the signal and noise subspaces.
}
\details{
The covariance matrix represents one Doppler cell of the averaged cross-spectra of three received signals. This matrix captures
the summation of signals from all bearings (plus noise) received by the antennas. To estimate the direction of arrival (DOA),
the covariance matrix is subjected to eigenvalue decomposition (diagonalization) to estimate the signal and noise subspaces.

In practical HF radar systems, there are two primary sources of noise:
\enumerate{
\item \emph{System (thermal) noise}: Generated by the receiving equipment and assumed to be uncorrelated between antennas.
\item \emph{Spatial noise field}: Includes wind-wave noise and current noise, modeled as Gaussian, which introduces correlation.
}

The eigenvalue decomposition produces:
\itemize{
\item Three eigenvalues, ordered from largest to smallest.
\item Three corresponding eigenvectors forming a 3-dimensional orthonormal basis.
}

Based on the largest eigenvalues:
\itemize{
\item If there is one signal present, the first eigenvector defines a 1-dimensional signal subspace, and the remaining eigenvectors
represent a 2-dimensional noise subspace.
\item If two signals are present, the first two eigenvectors form a 2-dimensional signal subspace, while the remaining eigenvector
represents a 1-dimensional noise subspace.
}

The signal and noise subspaces are orthogonal. This decomposition facilitates identifying the signal's direction by finding the
antenna manifold that best fits the signal subspace.
}
\references{
Paolo, T. de, Cook, T. & Terrill, E. Properties of HF RADAR Compact Antenna Arrays and Their Effect on the MUSIC Algorithm. OCEANS 2007 1–10 (2007) doi:10.1109/oceans.2007.4449265.
}
\seealso{
\code{\link{seasonder_MUSICComputeCov}} for computing the covariance matrix.
}
