% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICInitInterpolatedData}
\alias{seasonder_MUSICInitInterpolatedData}
\title{Initialize Interpolated Data for MUSIC Algorithm}
\usage{
seasonder_MUSICInitInterpolatedData(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeR cross-spectral object containing metadata about the number
of Doppler cells and range cells.}
}
\value{
A list containing the initialized interpolated data structure with placeholders for cross-spectral components.
}
\description{
This function initializes the data structure for storing interpolated cross-spectral data
to be used in the MUSIC algorithm.
}
\details{
The function retrieves the number of Doppler cells and range cells from the provided cross-spectral object
and uses this information to initialize the interpolated data structure. The resulting structure is
compatible with the dimensions of the cross-spectral data used in SeaSondeR.

The data structure is initialized using \code{\link{seasonder_initCSDataStructure}}, ensuring it contains
placeholders for components such as \code{SSA1}, \code{SSA2}, \code{SSA3}, \code{CS12}, \code{CS13},
\code{CS23}, and \code{QC}.
}
\seealso{
\code{\link{seasonder_initCSDataStructure}} for details on the cross-spectral data structure.
}
