% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_SmoothFORSS}
\alias{seasonder_SmoothFORSS}
\title{Smooth Self-Spectra for First Order Region (FOR)}
\usage{
seasonder_SmoothFORSS(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing self-spectra data.}
}
\value{
The input \code{SeaSondeRCS} object with the smoothed self-spectra stored as an attribute.
}
\description{
This function applies a smoothing operation to the self-spectra (SS) matrix of antenna 3
in a SeaSondeR cross-spectral object, specifically for First Order Region (FOR) processing.
The smoothed self-spectra are stored as an attribute within the object.
}
\details{
The function retrieves the default Doppler smoothing factor (\code{nsm}) from
\code{\link{seasonder_getFOR_parameters}} and applies the smoothing operation
using \code{\link{seasonder_SmoothSS}} on the self-spectra of antenna 3.

\strong{Steps:}
\enumerate{
\item Retrieve the Doppler smoothing factor (\code{nsm}).
\item Apply the sliding mean smoothing to the self-spectra of antenna 3.
\item Store the smoothed matrix as an attribute within the \code{SeaSondeRCS} object.
}

The smoothing process helps stabilize the estimation of nulls between first- and second-order
regions, preventing over-smoothing that could distort boundaries or under-smoothing that could
introduce jagged edges.
}
\seealso{
\itemize{
\item \code{\link{seasonder_SmoothSS}} for performing the smoothing operation.
\item \code{\link{seasonder_setSeaSondeRCS_FOR_SS_Smoothed}} for storing the smoothed self-spectra.
\item \code{\link{seasonder_getFOR_parameters}} for retrieving default \code{nsm} values.
}
}
