% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_specsHandling.R
\name{seasonder_defaultSpecsPathForFile}
\alias{seasonder_defaultSpecsPathForFile}
\title{Get the Default Specifications Path for a Spectra File}
\usage{
seasonder_defaultSpecsPathForFile(filepath, endian = "big")
}
\arguments{
\item{filepath}{A character string specifying the path to the spectra file.}

\item{endian}{A character string indicating the file's byte order ("big" by default).}
}
\value{
A character string representing the default YAML specifications file path for the detected file type.
}
\description{
This function returns the default YAML specifications file path corresponding to a given spectra file.
It first determines the file type by analyzing the file content and then retrieves the associated default
specifications path.
}
\details{
The function leverages \code{seasonder_find_spectra_file_type} to determine whether the file is of type "CS" or "CSSY".
It then uses \code{seasonder_defaultSpecsFilePath} to obtain the corresponding default specifications path.
}
\seealso{
\code{\link{seasonder_find_spectra_file_type}}, \code{\link{seasonder_defaultSpecsFilePath}}
}
