% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_estimateReferenceNoiseNormalizedLimits}
\alias{seasonder_estimateReferenceNoiseNormalizedLimits}
\title{Estimate Reference Noise Limits in Normalized Doppler Frequency}
\usage{
seasonder_estimateReferenceNoiseNormalizedLimits(
  seasonder_cs_object,
  low_limit = 0.95,
  high_limit = 1
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing Doppler frequency metadata.}

\item{low_limit}{Optional. A numeric value representing the fraction of the maximum normalized
Doppler frequency to be used as the lower bound for noise estimation. Default is 0.95.}

\item{high_limit}{Optional. A numeric value representing the fraction of the maximum normalized
Doppler frequency to be used as the upper bound for noise estimation. Default is 1.0.}
}
\value{
A numeric vector of length two, representing the lower and upper reference noise limits in
normalized Doppler frequency.
}
\description{
This function estimates the reference noise limits for normalized Doppler frequencies
in a SeaSondeR cross-spectral object. These limits define the frequency range over which
the noise floor is assessed for first-order region (FOR) detection.
}
\details{
The function operates as follows:
\enumerate{
\item Retrieves the Doppler bin frequencies in normalized units (relative to the Bragg frequency)
via \code{seasonder_getDopplerBinsFrequency}.
\item Computes the noise limits by scaling the maximum normalized Doppler frequency using the
provided \code{low_limit} and \code{high_limit} factors:
\itemize{
\item The lower bound is given by \code{max(freq) * low_limit}.
\item The upper bound is given by \code{max(freq) * high_limit}.
}
\item The default empirical choice for the lower bound (56.5\% in the original calibration process)
is adjustable via the \code{low_limit} parameter. This parameter was determined through an iterative
process where the initial lower bound was decreased in increments (e.g., 0.5\%) until the computed noise
floor closely matched the reference provided by the AnalyseSpectra Tool in Radial Suite R8.
}

This approach is crucial for setting the signal-to-noise ratio (SNR) thresholds used in FOR detection.
}
\seealso{
\code{\link{seasonder_getDopplerBinsFrequency}} for retrieving Doppler bin frequencies.
}
