% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_exportCSVMUSICTable}
\alias{seasonder_exportCSVMUSICTable}
\title{Export MUSIC Table to CSV}
\usage{
seasonder_exportCSVMUSICTable(seasonder_cs_object, filepath)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing MUSIC detection data.}

\item{filepath}{A character string specifying the path to the output CSV file.}
}
\value{
The function returns \code{NULL} invisibly. The output is saved to the specified file.
}
\description{
This function exports the MUSIC detection table from a \code{SeaSondeRCS} object to a CSV file.
}
\details{
This function performs the following steps:
\enumerate{
\item Generates a MUSIC table using \code{seasonder_exportMUSICTable}.
\item Converts the resulting table to a data frame.
\item Writes the data frame to the specified CSV file using \code{data.table::fwrite}.
}
}
\examples{
  # Prepare a SeaSondeRCS object for examples, including APM
  apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
  apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
  specs_path <- seasonder_defaultSpecsFilePath("CS")
  cs_obj <- seasonder_createSeaSondeRCS(
    system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR"),
    specs_path = specs_path,
    seasonder_apm_object = apm_obj
  )
cs_obj <- seasonder_initMUSICData(
 cs_obj,
 range_cells = c(rep(5,11), rep(4,11)),
 doppler_bins = c(c(669:679),c(674:684))
)
cs_obj <- seasonder_runMUSIC(cs_obj)
  # Export MUSIC table to a temporary CSV file
  tmpfile <- tempfile(fileext = ".csv")
  seasonder_exportCSVMUSICTable(cs_obj, tmpfile)
  print(tmpfile)
}
\seealso{
\itemize{
\item \code{\link{seasonder_exportMUSICTable}}
\item \code{\link[data.table]{fwrite}}
}
}
