% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}
\alias{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}
\title{Retrieve the Adjusted Doppler Spectrum Resolution for MUSIC Analysis}
\usage{
seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the data and parameters
for MUSIC analysis.}
}
\value{
A numeric value representing the adjusted Doppler spectrum resolution.
}
\description{
This function calculates the Doppler spectrum resolution adjusted by the Doppler
interpolation factor for a given \code{SeaSondeRCS} object. The adjustment ensures
that the spectrum resolution reflects the impact of interpolation applied in the
MUSIC analysis.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the base Doppler spectrum resolution using \code{\link{seasonder_getDopplerSpectrumResolution}}.
\item Obtains the Doppler interpolation factor using \code{\link{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}}.
\item Divides the base resolution by the interpolation factor to compute the adjusted resolution.
}

This adjustment is critical for accurately interpreting MUSIC data in cases where
Doppler interpolation has been applied.
}
\seealso{
\code{\link{seasonder_getDopplerSpectrumResolution}} to retrieve the base Doppler spectrum resolution.
\code{\link{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}} to retrieve the Doppler interpolation factor.
}
