% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_int_to_raw}
\alias{seasonder_int_to_raw}
\title{Convert an integer to raw bytes using a 64-bit representation}
\usage{
seasonder_int_to_raw(x)
}
\arguments{
\item{x}{An integer to be converted to raw bytes.}
}
\value{
A raw vector representing the 64-bit format of the provided integer.
}
\description{
This function converts an integer to a raw byte representation using a 64-bit (8-byte) format.
It leverages the \code{bit64} package to handle the 64-bit integer representation and conversion.
}
\details{
The function follows these steps:
\enumerate{
\item Convert the integer to a 64-bit format using \code{bit64::as.integer64}.
\item Convert the 64-bit integer to a bit string.
\item Split the bit string into individual bits.
\item Reorder the bits into groups of 8, reversing the order within each group.
\item Convert the reordered bits back to raw bytes.
}
}
