% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_readSeaSondeCSFileData}
\alias{seasonder_readSeaSondeCSFileData}
\title{Read SeaSonde Cross Spectra (CS) File Data}
\usage{
seasonder_readSeaSondeCSFileData(connection, header, endian = "big")
}
\arguments{
\item{connection}{A connection object to the CS file.}

\item{header}{A list containing the header information. This is typically the output
of the \code{seasonder_readSeaSondeCSFileHeader} function.}

\item{endian}{Character string indicating the byte order. Options are "big" (default) or "little".}
}
\value{
A list containing the processed CS file data including matrices for SSA*, CSxy, and QC (if applicable).
}
\description{
This function reads the SeaSonde CS file data based on the provided header information.
The CS file data includes the antenna voltage squared self spectra (\verb{SSA*}) and the
antenna cross spectra (\code{CSxy}). Additionally, a quality matrix (\code{QC}) is read when the header's
\code{nCsKind} is greater than or equal to 2.
}
\details{
\itemize{
\item \verb{SSA*}: Represents the Antenna * voltage squared self spectra. These are matrices
where each row corresponds to a range and each column to a Doppler cell.
\item \code{CSxy}: Represents the cross spectra between two antennas x and y. These are complex matrices.
\item \code{QC}: Quality matrix with values ranging from zero to one. A value less than one indicates
that the SpectraAverager skipped some data during averaging.
}
}
\section{Condition Management}{

This function utilizes the \code{rlang} package to manage errors and conditions, providing detailed and structured messages:

\strong{Error Classes}:
\itemize{
\item \code{"seasonder_cs_data_reading_error"}: This error is thrown when there is a problem reading the CS file data. This could be due to issues with the connection object or the file itself.
\item \code{"seasonder_cs_missing_header_info_error"}: Thrown if essential header information such as \code{nRangeCells}, \code{nDopplerCells}, or \code{nCsKind} is missing or invalid.
}

\strong{Error Cases}:
\itemize{
\item Connection object is not properly opened or is invalid.
\item Header information is incomplete or improperly formatted.
\item File read operations fail due to incorrect data size, type, or unexpected end of file.
\item Non-numeric values encountered where numeric spectra data is expected.
}
}

\examples{
con <- rawConnection(as.raw(rep(0, 300)))
header <- list(nRangeCells = 1, nDopplerCells = 5, nCsKind = 2)
data <- seasonder_readSeaSondeCSFileData(con, header, endian = "big")
print(data)
close(con)
}
