% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_runMUSICInFOR}
\alias{seasonder_runMUSICInFOR}
\alias{seasonder_runMUSIC_in_FOR}
\title{Run MUSIC Algorithm on FOR Data}
\usage{
seasonder_runMUSICInFOR(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing cross-spectra data and FOR information.
(Note: Although this parameter is specified as an argument in the documentation, the actual Doppler interpolation factor is retrieved from
the MUSIC options stored in the object.)}
}
\value{
A SeaSondeRCS object with its MUSIC data updated after applying Doppler interpolation, FOR extraction, and the complete MUSIC processing.
}
\description{
This function integrates the MUSIC (Multiple Signal Classification) algorithm into a SeaSondeRCS object that has First Order Regions (FOR) initialized.
It first applies Doppler interpolation to the cross-spectra data, then extracts the FOR boundaries for each range cell by transforming the negative
and positive FOR Doppler bins into frequency values and subsequently mapping these frequencies back to Doppler bins. Finally, the function initializes
the MUSIC data structure and invokes the full MUSIC algorithm to update the SeaSondeRCS object.
}
\details{
This function performs the following sequence of operations:
\enumerate{
\item It retrieves the Doppler interpolation factor from the MUSIC options of the input object.
\item It obtains the FOR data from the object using \code{seasonder_getSeaSondeRCS_FOR}.
\item For each range cell in the FOR data:
\enumerate{
\item It processes the negative FOR bins by:
\enumerate{
\item Determining the frequency range corresponding to the negative bins via \code{seasonder_Bins2DopplerFreq}.
\item Mapping these frequencies to new Doppler bin indices with \code{seasonder_MUSIC_DopplerFreq2Bins} and adjusting
the indices based on the interpolation factor.
}
\item It processes the positive FOR bins in an analogous manner.
\item If valid Doppler bin indices are obtained, a data frame is created recording the range cell and Doppler bin information.
}
\item The function compiles the extracted FOR information from all range cells into a single data frame.
\item It initializes the MUSIC data structure for the specified range cells and Doppler bins using \code{seasonder_initMUSICData}.
\item Finally, it calls \code{seasonder_runMUSIC} to execute the MUSIC algorithm on the updated object.
}
}
\examples{
# Prepare a SeaSondeRCS object with MUSIC data (including FOR segments)
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
FOR <- seasonder_getSeaSondeRCS_FOR(cs_obj)
cs_obj <- seasonder_setSeaSondeRCS_FOR(cs_obj,FOR[4:5])
# Run MUSIC algorithm in FOR context
result <- seasonder_runMUSICInFOR(cs_obj)
# View processing steps
print(seasonder_getSeaSondeRCS_ProcessingSteps(result))
}
