% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{fastboost_gamlss}
\alias{fastboost_gamlss}
\title{FastBoost for GAMLSS (lightweight stability selection)}
\usage{
fastboost_gamlss(
  formula,
  data,
  family,
  mu_scope,
  sigma_scope = NULL,
  nu_scope = NULL,
  tau_scope = NULL,
  base_sigma = ~1,
  base_nu = ~1,
  base_tau = ~1,
  B = 30,
  sample_fraction = 0.6,
  pi_thr = 0.6,
  k = 2,
  direction = c("both", "forward", "backward"),
  pre_standardize = FALSE,
  use_groups = TRUE,
  c0 = 0.5,
  trace = TRUE,
  corr_func = "cor",
  group_fun = SelectBoost::group_func_2,
  ...
)
}
\arguments{
\item{formula}{Base formula for the location \eqn{\mu} parameter (in the main model call).}

\item{data}{Data frame.}

\item{family}{A \code{gamlss.dist} family object (e.g., \code{gamlss.dist::NO()}).}

\item{mu_scope}{Formula of candidate terms for \eqn{\mu}.}

\item{sigma_scope, nu_scope, tau_scope}{Formulas of candidate terms for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{base_sigma, base_nu, base_tau}{Optional base (always-included) formulas for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{B}{Number of bootstrap subsamples for stability selection.}

\item{sample_fraction}{Fraction of rows per subsample (e.g., 0.7).}

\item{pi_thr}{Selection proportion threshold to define “stable” terms (e.g., 0.6).}

\item{k}{Penalty weight for stepwise GAIC when \code{engine = "stepGAIC"} (default 2).}

\item{direction}{Stepwise direction for \code{stepGAIC} (\code{"both"}, \code{"forward"}, \code{"backward"}).}

\item{pre_standardize}{Logical; standardize numeric predictors before penalized fits.}

\item{use_groups}{Logical; treat SelectBoost correlation groups during resampling.}

\item{c0}{SelectBoost meta-parameter controlling reweighting/thresholding (see vignette).}

\item{trace}{Logical; print progress messages.}

\item{corr_func}{Correlation function passed to \code{SelectBoost::boost.compcorrs}.}

\item{group_fun}{Grouping function passed to \code{SelectBoost::boost.findgroups}.}

\item{...}{Passed to underlying engines (e.g., to \code{gamlss::gamlss}, \code{glmnet}, etc.).}
}
\value{
An \code{sb_gamlss} fit at the given \code{c0}.
}
\description{
A faster variant with fewer bootstraps and smaller subsamples.
}
\details{
Fast SelectBoost (single c0)
}
