% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_hierarchical_prior_binomial}
\alias{SSS_hierarchical_prior_binomial}
\title{Compute marginal posterior probabilities (slab probabilities) that data points have
  non-zero mean using the general hierarchical prior algorithm, but specialized to
  the Beta[kappa,lambda]-binomial prior. This function is equivalent to calling
  \code{\link{SSS_hierarchical_prior}} with
  logprior = lbeta(kappa+(0:n),lambda+n-(0:n)) - lbeta(kappa,lambda) + lchoose(n,0:n),
  but more convenient when using the Beta[kappa,lambda]-binomial prior and with a
  minor interior optimization that avoids calculating the choose explicitly.}
\usage{
SSS_hierarchical_prior_binomial(
  log_phi_psi,
  kappa,
  lambda,
  show_progress = TRUE
)
}
\arguments{
\item{log_phi_psi}{List \{logphi, logpsi\} containing two vectors of the same length n
that represent a preprocessed version of the data. logphi and logpsi should contain
the logs of the phi and psi densities of the data points, as produced for instance
by \code{\link{SSS_log_phi_psi_Laplace}} or \code{\link{SSS_log_phi_psi_Cauchy}}}

\item{kappa}{First parameter of the beta-distribution}

\item{lambda}{Second parameter of the beta-distribution}

\item{show_progress}{Boolean that indicates whether to show a progress bar}
}
\value{
Returns a vector with marginal posterior slab probabilities that \eqn{x[i]} has
  non-zero mean for \eqn{i=1,...,n}.
}
\description{
Compute marginal posterior probabilities (slab probabilities) that data points have
  non-zero mean using the general hierarchical prior algorithm, but specialized to
  the Beta[kappa,lambda]-binomial prior. This function is equivalent to calling
  \code{\link{SSS_hierarchical_prior}} with
  logprior = lbeta(kappa+(0:n),lambda+n-(0:n)) - lbeta(kappa,lambda) + lchoose(n,0:n),
  but more convenient when using the Beta[kappa,lambda]-binomial prior and with a
  minor interior optimization that avoids calculating the choose explicitly.
}
