% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_postmean_Laplace}
\alias{SSS_postmean_Laplace}
\title{Compute posterior means of data points for the Laplace(lambda) slab}
\usage{
SSS_postmean_Laplace(x, logpsi, postprobs, sigma, lambda)
}
\arguments{
\item{x}{Data vector of length n}

\item{logpsi}{Vector of length n that represents a preprocessed version of the data.
It should contain the logs of the psi densities of the data points, as produced 
by \code{\link{SSS_log_phi_psi_Laplace}}.}

\item{postprobs}{Vector of marginal posterior slab probabilities that \eqn{x[i]} has
non-zero mean for \eqn{i=1,...,n}.}

\item{sigma}{standard deviation of observations}

\item{lambda}{parameter of Laplace slab density}
}
\value{
Vector of n posterior means
}
\description{
Compute posterior means of data points for the Laplace(lambda) slab
}
