% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pphi.omni.R
\name{pphi.omni}
\alias{pphi.omni}
\title{calculate the left-tail probability of omnibus phi-divergence statistics under general correlation matrix.}
\usage{
pphi.omni(q, M, K0, K1, S, t = 30, onesided = FALSE, method = "ecc", ei = NULL)
}
\arguments{
\item{q}{- quantile, must be a scalar.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{K0}{- vector of search range starts (from the k0th smallest p-value).}

\item{K1}{- vector of search range ends (at the k1th smallest p-value).}

\item{S}{- vector of the phi-divergence test parameters.}

\item{t}{- numerical truncation parameter.}

\item{onesided}{- TRUE if the input p-values are one-sided.}

\item{method}{- default = "ecc": the effective correlation coefficient method in reference 2. "ave": the average method in reference 3, which is an earlier version of reference 2. The "ecc" method is more accurate and numerically stable than "ave" method.}

\item{ei}{- the eigenvalues of M if available.}
}
\value{
Left-tail probability of omnibus phi-divergence statistics.
}
\description{
calculate the left-tail probability of omnibus phi-divergence statistics under general correlation matrix.
}
\examples{
M = matrix(0.3,10,10) + diag(1-0.3, 10)
pphi.omni(0.05, M=M, K0=rep(1,2), K1=rep(5,2), S=c(1,2))
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and power of optimal signal-detection statistics in finite case", IEEE Transactions on Signal Processing (2020) 68, 1021-1033
2. Hong Zhang and Zheyang Wu. "The general goodness-of-fit tests for correlated data", Computational Statistics & Data Analysis (2022) 167, 107379
3. Hong Zhang and Zheyang Wu. "Generalized Goodness-Of-Fit Tests for Correlated Data", arXiv:1806.03668.
}
