% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qphi.R
\name{qphi}
\alias{qphi}
\title{Quantile of phi-divergence statistic under the null hypothesis.}
\usage{
qphi(
  p,
  M,
  k0,
  k1,
  s = 2,
  t = 30,
  onesided = FALSE,
  method = "ecc",
  ei = NULL,
  err_thr = 1e-04
)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{k0}{- search range starts from the k0th smallest p-value.}

\item{k1}{- search range ends at the k1th smallest p-value.}

\item{s}{- the phi-divergence test parameter.}

\item{t}{- numerical truncation parameter.}

\item{onesided}{- TRUE if the input p-values are one-sided.}

\item{method}{- default = "ecc": the effective correlation coefficient method in reference 2. "ave": the average method in reference 3, which is an earlier version of reference 2. The "ecc" method is more accurate and numerically stable than "ave" method.}

\item{ei}{- the eigenvalues of M if available.}

\item{err_thr}{- the error threshold. The default value is 1e-4.}
}
\value{
Quantile of the phi-divergence statistics.
}
\description{
Quantile of phi-divergence statistic under the null hypothesis.
}
\examples{
qphi(p=.95, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE)
qphi(p=1-1e-3, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE)
qphi(p=1-1e-3, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE, err_thr = 1e-6)
qphi(p=1-1e-5, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE)
qphi(p=1-1e-5, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE, err_thr = 1e-6)
qphi(p=1-1e-5, M=diag(10), k0=1, k1=5, s=2, onesided=FALSE, err_thr = 1e-8)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and power of optimal signal-detection statistics in finite case", IEEE Transactions on Signal Processing (2020) 68, 1021-1033
2. Hong Zhang and Zheyang Wu. "The general goodness-of-fit tests for correlated data", Computational Statistics & Data Analysis (2022) 167, 107379
3. Hong Zhang and Zheyang Wu. "Generalized Goodness-Of-Fit Tests for Correlated Data", arXiv:1806.03668.
}
\seealso{
\code{\link{stat.phi}} for the definition of the statistic.
}
