% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeatherVienna.R
\docType{data}
\name{WeatherVienna}
\alias{WeatherVienna}
\title{Weather data from Vienna}
\format{
A data frame with 1,804 rows and 25 columns:
\describe{
  \item{\code{year}}{Year}
  \item{\code{month}}{Month}
  \item{\code{t}}{Daily mean air temperature in °C, (t7 mean + t19 mean + tmax mean + tmin mean)/4; before 1971: t7 mean + t14 mean + 2 x t21 mean)}
  \item{\code{t_max}}{Absolute maximum air temperature in °C}
  \item{\code{t_min}}{Absolute air temperature minimum in °C}
  \item{\code{avg_t_max}}{Mean daily maximum air temperature in °C}
  \item{\code{avg_t_min}}{Mean daily minimum air temperature in °C}
  \item{\code{num_frost}}{Number of frost days (days with a temperature maximum tmin < 0.0 °C)}
  \item{\code{num_ice}}{Number of ice days (days with a temperature maximum tmax < 0.0 °C)}
  \item{\code{num_summer}}{Number of summer days (days with a temperature maximum tmax >= 25.0 °C)}
  \item{\code{num_heat}}{Number of hot days (days with a temperature maximum tmax >= 30.0 °C)}
  \item{\code{p}}{Daily mean air pressure in hPa (mean of all measurements at 7 a.m., 2 p.m., 7 p.m. CET; before 1971 9 p.m. instead of 7 p.m.)}
  \item{\code{p_max}}{Maximum air pressure in hPa (maximum of all measurements7 am, 2 pm, 7 pm CET; before 1971 9 pm instead of 7 pm)}
  \item{\code{p_min}}{Minimum air pressure in hPa (minimum of all measurements7 am, 2 pm, 7 pm CET; before 1971 9 pm instead of 7 pm)}
  \item{\code{sun_h}}{Monthly total sunshine duration in hours}
  \item{\code{num_clear}}{Number of clear days (daily mean cloudiness < 20/100)}
  \item{\code{num_cloud}}{Number of cloudy days (daily mean cloudiness > 80/100)}
  \item{\code{rel_hum}}{Daily mean relative humidity in percent (2 x RH7 mean + RH14 mean + RH19 mean)/4; before 1971 9 p.m. instead of 7 p.m.)}
  \item{\code{rel_hum_max}}{Relative humidity maximum in percent}
  \item{\code{rel_hum_min}}{Relative humidity minimum in percent}
  \item{\code{wind_v}}{Monthly average wind speed in km/h}
  \item{\code{num_wind_v60}}{Number of days with wind peaks >= 60 km/h}
  \item{\code{wind_v_max}}{Maximum wind speed in km/h}
  \item{\code{precp_sum}}{Monthly total precipitation in mm}
  \item{\code{num_precp_01}}{Number of days with precipitation >= 0.1 mm}
}
}
\source{
The data were downloaded from \code{https://www.data.gv.at/katalog/dataset/wetter-seit-1872-hohe-warte-wien} in September 2022.
}
\usage{
WeatherVienna
}
\description{
Monthly data from the weather station Hohe Warte since April 1872 - Vienna \insertCite{weather}{ShapleyOutlier}.
}
\examples{
data("WeatherVienna")
summary(WeatherVienna)
}
\references{
\insertRef{weather}{ShapleyOutlier}
}
\keyword{datasets}
