% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sherlock.R
\name{coChronology}
\alias{coChronology}
\title{coChronology}
\usage{
coChronology(titles.vec, patterns, starts, freqs, chronDir)
}
\arguments{
\item{titles.vec}{character vector containing the titles of the stories}

\item{patterns}{vector of character string query patterns}

\item{starts}{integer vector of starting positions}

\item{freqs}{return value of frequency()}

\item{chronDir}{character string full path name for output directory}
}
\value{
returns an integer matrix whose rows are search patterns
and columns are stories, value of 1 indicates the presence of the
corresponding search pattern in the corresponding story
}
\description{
graphical indicator of search patterns within stories
}
\examples{
freqDir<-tempdir()
chronDir<-sprintf("\%s/chronology",freqDir)
dir.create(chronDir)
dir.create(sprintf("\%s/plots",chronDir))
dir.create(sprintf("\%s/archive",chronDir))
print(chronDir)
coch<-coChronology(titles.vec,c("Holmes","Watson"),starts,freqs,chronDir)
}
