% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantification.R
\name{FeatureMatrix}
\alias{FeatureMatrix}
\title{Feature Matrix}
\usage{
FeatureMatrix(
  fragments,
  features,
  keep_all_features = FALSE,
  cells = NULL,
  process_n = 2000,
  sep = c("-", "-"),
  verbose = TRUE
)
}
\arguments{
\item{fragments}{A list of \code{\link{Fragment}} objects. Note that if
setting the \code{cells} parameter, the requested cells should be present in
the supplied \code{Fragment} objects. However, if the cells information in
the fragment object is not set (\code{Cells(fragments)} is \code{NULL}), then
the fragment object will still be searched.}

\item{features}{A GRanges object containing a set of genomic intervals.
These will form the rows of the matrix, with each entry recording the number
of unique reads falling in the genomic region for each cell.}

\item{keep_all_features}{By default, if a genomic region provided is on a
chromosome that is not present in the fragment file,
it will not be included in the returned matrix. Set `keep_all_features` to
TRUE to force output to include all features in the input ranges. Note that
features on chromosomes that are not present in the fragment file will be 
filled with zero counts.}

\item{cells}{Vector of cells to include. If NULL, include all cells found
in the fragments file}

\item{process_n}{Number of regions to load into memory at a time, per thread.
Processing more regions at once can be faster but uses more memory.}

\item{sep}{Vector of separators to use for genomic string. First element is
used to separate chromosome and coordinates, second separator is used to
separate start and end coordinates.}

\item{verbose}{Display messages}
}
\value{
Returns a sparse matrix
}
\description{
Construct a feature x cell matrix from a genomic fragments file
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(fpath)
FeatureMatrix(
  fragments = fragments,
  features = granges(atac_small)
)
}
\concept{quantification}
