% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_ord.R
\name{norm_ord}
\alias{norm_ord}
\title{Calculate Correlations of Ordinal Variables Obtained from Discretizing Normal Variables}
\usage{
norm_ord(marginal = list(), Sigma = NULL, support = list(),
  Spearman = FALSE)
}
\arguments{
\item{marginal}{a list of length equal to the number of variables; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1)}

\item{Sigma}{the correlation matrix of the multivariate standard normal variable}

\item{support}{a list of length equal to the number of variables; the i-th element is a vector of containing the r
ordered support values; if not provided (i.e. support = list()), the default is for the i-th element to be the vector 1, ..., r}

\item{Spearman}{if TRUE, Spearman's correlations are used (and support is not required); if FALSE (default) Pearson's correlations
are used}
}
\value{
the correlation matrix of the ordinal variables
}
\description{
This function calculates the correlation of ordinal variables (or variables treated as "ordinal"), with given marginal
    distributions, obtained from discretizing standard normal variables with a specified correlation matrix.  The function modifies
    Barbiero & Ferrari's \code{\link[GenOrd]{contord}} function in \code{\link[GenOrd]{GenOrd-package}}.  It uses
    \code{\link[mvtnorm]{pmvnorm}} function from the \strong{mvtnorm} package to calculate multivariate normal cumulative probabilities
    defined by the normal quantiles obtained at \code{marginal} and the supplied correlation matrix \code{Sigma}.  This function is used
    within \code{\link[SimCorrMix]{ord_norm}} and would not ordinarily be called by the user.
}
\references{
Please see references in \code{\link[SimCorrMix]{ord_norm}}.

Alan Genz, Frank Bretz, Tetsuhisa Miwa, Xuefei Mi, Friedrich Leisch, Fabian Scheipl, Torsten Hothorn (2018).
  mvtnorm: Multivariate Normal and t Distributions. R package version 1.0-8. \url{https://CRAN.R-project.org/package=mvtnorm}.

Alan Genz, Frank Bretz (2009), Computation of Multivariate Normal and t Probabilities. Lecture Notes in Statistics, Vol. 195.,
  Springer-Verlag, Heidelberg. ISBN 978-3-642-01688-2.
}
\seealso{
\code{\link[SimCorrMix]{ord_norm}}
}
\keyword{continuous}
\keyword{correlation}
\keyword{ordinal}
