% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIS.R
\name{u0_SIS}
\alias{u0_SIS}
\title{Example data to initialize the \sQuote{SIS} model}
\usage{
u0_SIS()
}
\value{
A \code{data.frame}
}
\description{
Example data to initialize a population of 1600 nodes and
demonstrate the \code{\linkS4class{SIS}} model.
}
\details{
A \code{data.frame} with the number of individuals in the
\sQuote{S}, and \sQuote{I} compartments in 1600 nodes. Note that
the \sQuote{I} compartment is zero.
}
\examples{
\dontrun{
## For reproducibility, call the set.seed() function and specify
## the number of threads to use. To use all available threads,
## remove the set_num_threads() call.
set.seed(123)
set_num_threads(1)

## Create an 'SIS' model with 1600 nodes and initialize
## it to run over 4*365 days. Add one infected individual
## to the first node.
u0 <- u0_SIS()
u0$I[1] <- 1
tspan <- seq(from = 1, to = 4*365, by = 1)
model <- SIS(u0     = u0,
             tspan  = tspan,
             events = events_SIS(),
             beta   = 0.16,
             gamma  = 0.01)

## Run the model to generate a single stochastic trajectory.
result <- run(model)
plot(result)

## Summarize trajectory
summary(result)
}
}
