% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_strat.R
\name{strat_means}
\alias{strat_means}
\title{Calculate stratified means, variances, and confidence intervals across groups}
\usage{
strat_means(
  data = NULL,
  metric = NULL,
  strat_groups = NULL,
  survey_groups = NULL,
  confidence = 95
)
}
\arguments{
\item{data}{A \code{data.table} with all grouping variables in stacked format. Must include
\code{strat_area} and \code{tow_area} for scaling values.}

\item{metric}{Name of the variable in \code{data.table} to summarize (e.g., \code{"number"}, \code{"mass"}).}

\item{strat_groups}{Grouping variables for fine-scale stratum-level means.
Must include \code{"strat"} and \code{"strat_area"}.
Example: \code{c("year", "species", "shiptrip", "NAFOdiv", "strat", "strat_area", "age")}}

\item{survey_groups}{Grouping variables for large-scale summary calculations
Example: \code{c("year", "species")}}

\item{confidence}{Confidence limit percentage (e.g., 95 for 95\% CI).}
}
\value{
A \code{data.table} containing stratified estimates of abundance.
}
\description{
This function is primarily designed for use within \code{\link[=run_strat]{run_strat()}}. It first calculates
statistics at the stratum level and then computes broader summaries like total abundance.
}
