% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{NAP}
\alias{NAP}
\title{Non-overlap of all pairs}
\usage{
NAP(
  A_data,
  B_data,
  condition,
  outcome,
  baseline_phase = NULL,
  intervention_phase = NULL,
  improvement = "increase",
  SE = "unbiased",
  confidence = 0.95,
  trunc_const = FALSE
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}

\item{SE}{character value indicating which formula to use for calculating the
standard error of NAP, with possible values \code{"unbiased"} for the
exactly unbiased estimator, \code{"Hanley"} for the Hanley-McNeil
estimator, \code{"null"} for the (known) variance under the null hypothesis
of no effect, or \code{"none"} to not calculate a standard error. Defaults
to "unbiased".}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}

\item{trunc_const}{logical value indicating whether to return the truncation
constant used to calculate the standard error.}
}
\value{
A data.frame containing the estimate, standard error, and/or
  confidence interval.
}
\description{
Calculates the non-overlap of all pairs index (Parker & Vannest,
  2009).
}
\details{
NAP is calculated as the proportion of all pairs of one observation
  from each phase in which the measurement from the B phase improves upon the
  measurement from the A phase, with pairs of data points that are exactly
  tied being given a weight of 0.5. The range of NAP is [0,1], with a null
  value of 0.5.

  The unbiased variance estimator was described by Sen (1967) and Mee (1990).
  The Hanley estimator was proposed by Hanley and McNeil (1982). The null
  variance is a known function of sample size, equal to the exact sampling
  variance when the null hypothesis of no effect holds. When the null
  hypothesis does not hold, the null variance will tend to over-estimate the
  true sampling variance of NAP.

  The confidence interval for NAP is calculated based on the symmetrized
  score-inversion method (Method 5) proposed by Newcombe (2006).
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
NAP(A_data = A, B_data = B)

# Example from Parker & Vannest (2009)
yA <- c(4, 3, 4, 3, 4, 7, 5, 2, 3, 2)
yB <- c(5, 9, 7, 9, 7, 5, 9, 11, 11, 10, 9)
NAP(yA, yB)

}
\references{
Hanley, J. A., & McNeil, B. J. (1982). The meaning and use of the area under
a receiver operating characteristic (ROC) curve. \emph{Radiology, 143},
29--36. doi:\doi{10.1148/radiology.143.1.7063747}

Mee, W. (1990). Confidence intervals for probabilities and tolerance regions
based on a generalization of the Mann-Whitney statistic. \emph{Journal of the
American Statistical Association, 85}(411), 793-800.
doi:\doi{10.1080/01621459.1990.10474942}

Newcombe, R. G. (2006). Confidence intervals for an effect size measure based
on the Mann-Whitney statistic. Part 2: Asymptotic methods and evaluation.
\emph{Statistics in Medicine, 25}(4), 559--573. doi:\doi{10.1002/sim.2324}

Parker, R. I., & Vannest, K. J. (2009). An improved effect size for
single-case research: Nonoverlap of all pairs. \emph{Behavior Therapy,
40}(4), 357--67. doi:\doi{10.1016/j.beth.2008.10.006}

Sen, P. K. (1967). A note on asymptotically distribution-free confidence
bounds for P\{X<Y\}, based on two independent samples. \emph{The Annals of
Mathematical Statistics, 29}(1), 95-102.
\href{https://www.jstor.org/stable/25049448}{https://www.jstor.org/stable/25049448}
}
