% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_Boxplot.R,
%   R/class_Kobe.R, R/class_MPs.R, R/class_OMs.R, R/class_Quilt.R,
%   R/class_Tradeoff.R, R/class_Timeseries.R, R/class_Spider.R, R/class_Slick.R
\name{Check}
\alias{Check}
\alias{Check,Boxplot-method}
\alias{Check,Kobe-method}
\alias{Check,MPs-method}
\alias{Check,OMs-method}
\alias{Check,Quilt-method}
\alias{Check,Tradeoff-method}
\alias{Check,Timeseries-method}
\alias{Check,Spider-method}
\alias{Check,Slick-method}
\title{Check an object for errors or issues}
\usage{
Check(object, ...)

\S4method{Check}{Boxplot}(object, req_dims = c(NA, NA, NA, NA))

\S4method{Check}{Kobe}(object)

\S4method{Check}{MPs}(object)

\S4method{Check}{OMs}(object)

\S4method{Check}{Quilt}(object)

\S4method{Check}{Tradeoff}(object)

\S4method{Check}{Timeseries}(object)

\S4method{Check}{Spider}(object)

\S4method{Check}{Slick}(object)
}
\arguments{
\item{object}{An object of class: \code{\link[=Slick-class]{Slick-class()}}, \code{\link[=MPs-class]{MPs-class()}},
\code{\link[=OMs-class]{OMs-class()}} or the six chart types: \code{\link[=Boxplot-class]{Boxplot-class()}}, \code{\link[=Kobe-class]{Kobe-class()}},
\code{\link[=Quilt-class]{Quilt-class()}}, \code{\link[=Spider-class]{Spider-class()}}, \code{\link[=Timeseries-class]{Timeseries-class()}},
and \code{\link[=Tradeoff-class]{Tradeoff-class()}}.}

\item{...}{Additional arguments}

\item{req_dims}{Required dimensions for \code{Value} slot. Used internally}
}
\value{
Prints messages to the console
}
\description{
Checks S4 objects to check for warnings and errors
}
\section{Methods (by class)}{
\itemize{
\item \code{Check(Boxplot)}: Check \code{\link[=Boxplot-class]{Boxplot-class()}} objects for errors

\item \code{Check(Kobe)}: Check \code{\link[=Kobe-class]{Kobe-class()}} objects for errors

\item \code{Check(MPs)}: Check \code{\link[=MPs-class]{MPs-class()}} objects for errors

\item \code{Check(OMs)}: Check \code{\link[=OMs-class]{OMs-class()}} objects for errors

\item \code{Check(Quilt)}: Check \code{\link[=Quilt-class]{Quilt-class()}} objects for errors

\item \code{Check(Tradeoff)}: Check \code{\link[=Tradeoff-class]{Tradeoff-class()}} objects for errors

\item \code{Check(Timeseries)}: Check \code{\link[=Timeseries-class]{Timeseries-class()}} objects for errors

\item \code{Check(Spider)}: Check \code{\link[=Spider-class]{Spider-class()}} objects for errors

\item \code{Check(Slick)}: Check \code{\link[=Slick-class]{Slick-class()}} objects for errors

}}
\examples{
slick <- Slick()
Check(slick)
}
