% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnv.R
\name{prep_cnv_dat}
\alias{prep_cnv_dat}
\title{Prepare data for CNV heat map}
\usage{
prep_cnv_dat(
  dat_bin,
  lower = 0.6,
  upper = 1.4,
  hc_function = "ward.D2",
  plot_directory
)
}
\arguments{
\item{dat_bin}{data.table of CNV scores per bin}

\item{lower}{numeric float to represent the lower cap for CNV scores}

\item{upper}{numeric float to represent the upper cap for CNV scores}

\item{hc_function}{character for which hierarchical clustering function to use}

\item{plot_directory}{output plot directory path}
}
\value{
A list object for downstream cnv plotting and analysis
all = data.table of CNV scores of all bins x (metadata + genes)
malig = data.table of CNV scores of just malignant bins x (metadata + genes)
all_wide = data.frame in wide format of CNV scores of all bins x (metadata + genes)
malig_wide = data.frame in wide format of CNV scores of just malignant bins x (metadata + genes)
hcl = hclust object that describes the hierarchical clustering for malignant bins
hcl_all = hclust object that describes the hierarchical clustering for all bins
}
\description{
This function caps CNV scores, adds annotation columns for plotting,
performs hierarchical clustering of bins based on similar CNV score, and plots nUMI per bin
}
